<?php

if(!function_exists('hudson_edge_register_required_plugins')) {
    /**
     * Registers Visual Composer, Layer Slider, Revolution Slider, Edge Core, Edge Instagram Feed, Edgef Twitter Feed  as required plugins. Hooks to tgmpa_register hook
     */
    function hudson_edge_register_required_plugins() {
        $plugins = array(
            array(
                'name'               => esc_html__('WPBakery Visual Composer', 'hudson'),
                'slug'               => 'js_composer',
                'source'             => get_template_directory().'/plugins/js_composer.zip',
                'required'           => true,
                'version'            => '6.0.5',
                'force_activation'   => false,
                'force_deactivation' => false,
                'external_url'       => ''
            ),
            array(
                'name'                  => esc_html__('LayerSlider WP', 'hudson'),
                'slug'                  => 'LayerSlider',
                'source'                => get_template_directory() . '/plugins/LayerSlider.zip',
                'required'              => true,
                'version'               => '6.9.1',
                'force_activation'      => false,
                'force_deactivation'    => false,
                'external_url'          => ''
            ),
            array(
                'name'               => esc_html__('Edge CPT', 'hudson'),
                'slug'               => 'edge-cpt',
                'source'             => get_template_directory().'/plugins/edge-cpt.zip',
                'required'           => true,
                'version'            => '1.2',
                'force_activation'   => false,
                'force_deactivation' => false,
                'external_url'       => ''
            ),
            array(
                'name'               => esc_html__('Hudson Instagram Feed', 'hudson'),
                'slug'               => 'hudson-instagram-feed',
                'source'             => get_template_directory().'/plugins/hudson-instagram-feed.zip',
                'required'           => true,
                'version'            => '1.0',
                'force_activation'   => false,
                'force_deactivation' => false,
                'external_url'       => ''
            ),
            array(
                'name'                  => esc_html__('Envato Market', 'hudson'),
                'slug'                  => 'envato-market', // The plugin slug (typically the folder name).
                'source'                => 'https://envato.github.io/wp-envato-market/dist/envato-market.zip', // The plugin source.
                'required'              => true,
                'version'               => '2.0.1',
                'force_activation'      => false,
                'force_deactivation'    => false,
                'external_url'          => '',
            ),
            array(
                'name'                  => esc_html__( 'WooCommerce', 'hudson' ),
                'slug'                  => 'woocommerce',
                'external_url'          => 'https://wordpress.org/plugins/woocommerce/',
                'required'              => false
            ),
            array(
                'name'                  => esc_html__( 'Contact Form 7', 'hudson' ),
                'slug'                  => 'contact-form-7',
                'external_url'          => 'https://wordpress.org/plugins/contact-form-7/',
                'required'              => false
            )
        );

        $config = array(
            'domain'           => 'hudson',
            'default_path'     => '',
            'parent_slug'      => 'themes.php',
            'capability'       => 'edit_theme_options',
            'menu'             => 'install-required-plugins',
            'has_notices'      => true,
            'is_automatic'     => false,
            'message'          => '',
            'strings'          => array(
                'page_title'                      => esc_html__('Install Required Plugins', 'hudson'),
                'menu_title'                      => esc_html__('Install Plugins', 'hudson'),
                'installing'                      => esc_html__('Installing Plugin: %s', 'hudson'),
                'oops'                            => esc_html__('Something went wrong with the plugin API.', 'hudson'),
                'notice_can_install_required'     => _n_noop('This theme requires the following plugin: %1$s.', 'This theme requires the following plugins: %1$s.', 'hudson'),
                'notice_can_install_recommended'  => _n_noop('This theme recommends the following plugin: %1$s.', 'This theme recommends the following plugins: %1$s.', 'hudson'),
                'notice_cannot_install'           => _n_noop('Sorry, but you do not have the correct permissions to install the %s plugin. Contact the administrator of this site for help on getting the plugin installed.', 'Sorry, but you do not have the correct permissions to install the %s plugins. Contact the administrator of this site for help on getting the plugins installed.', 'hudson'),
                'notice_can_activate_required'    => _n_noop('The following required plugin is currently inactive: %1$s.', 'The following required plugins are currently inactive: %1$s.', 'hudson'),
                'notice_can_activate_recommended' => _n_noop('The following recommended plugin is currently inactive: %1$s.', 'The following recommended plugins are currently inactive: %1$s.', 'hudson'),
                'notice_cannot_activate'          => _n_noop('Sorry, but you do not have the correct permissions to activate the %s plugin. Contact the administrator of this site for help on getting the plugin activated.', 'Sorry, but you do not have the correct permissions to activate the %s plugins. Contact the administrator of this site for help on getting the plugins activated.', 'hudson'),
                'notice_ask_to_update'            => _n_noop('The following plugin needs to be updated to its latest version to ensure maximum compatibility with this theme: %1$s.', 'The following plugins need to be updated to their latest version to ensure maximum compatibility with this theme: %1$s.', 'hudson'),
                'notice_cannot_update'            => _n_noop('Sorry, but you do not have the correct permissions to update the %s plugin. Contact the administrator of this site for help on getting the plugin updated.', 'Sorry, but you do not have the correct permissions to update the %s plugins. Contact the administrator of this site for help on getting the plugins updated.', 'hudson'),
                'install_link'                    => _n_noop('Begin installing plugin', 'Begin installing plugins', 'hudson'),
                'activate_link'                   => _n_noop('Activate installed plugin', 'Activate installed plugins', 'hudson'),
                'return'                          => esc_html__('Return to Required Plugins Installer', 'hudson'),
                'plugin_activated'                => esc_html__('Plugin activated successfully.', 'hudson'),
                'complete'                        => esc_html__('All plugins installed and activated successfully. %s', 'hudson'),
                'nag_type'                        => 'updated'
            )
        );

        tgmpa($plugins, $config);
    }

    add_action('tgmpa_register', 'hudson_edge_register_required_plugins');
}

/**
 * Force Visual Composer to initialize as "built into the theme". This will hide certain tabs under the Settings->Visual Composer page
 */
if(function_exists('vc_set_as_theme')) vc_set_as_theme(true);

// Initialising Shortcodes
if (class_exists('WPBakeryVisualComposerAbstract')) {
    function hudson_edge_require_vc_extend(){
        if( hudson_edge_is_core_installed() && defined('EDGE_CORE_VERSION') && EDGE_CORE_VERSION >= 1.1  ) {
            require_once HUDSON_EDGE_ROOT_DIR . '/extendvc/extend-vc.php';
        }
    }
    add_action('after_setup_theme', 'hudson_edge_require_vc_extend', 2);
}
?>
